clear all;
close all;
clc;

% ABS via trust region-based ESC

% define the global variable
global A B InvWc x0 lambdas t0 t1 c R m B N; 
global usave tsave

usave=[]; tsave=[];


% Consider a state feedback linearizable nonlinear systemes
% m x1dot=-N*mu
% I x2dot=-B*x2+N*R*mu-u
%
% After feedback linearzation, the resulting system will behave as
% following (A,B) in terms of new state z

% system parameter
c=1;
R=0.3;
m=400;
B=0.01;
N=m*9.8;
I=m*R*R;
 
lambdastar=0.25;

% stable system matrix
A=-c;
B=1;  

t0=0;  % start time
t1=6;  % end5 time
dt=0.6% regulation time bewteen each step
flag=1; 
num=t1/dt;  % number of search steps
%initial condition of the state 
x0=[100/3;400/3.6];   
xhat(:,1)=x0(1:2);   % real regulated state
lambdasr(1)=(x0(1)-R*x0(2))/x0(1);   % desired regulated state
Nx=0;          % counter of state
Nu=0;          % counter of control
Nt=0;          % counter of time
TIME=6;        % simulation stops at 6 sec
% trust region algorithm paramters
hk=0.55;
eta=0.2;

% %no noise
% hk=0.245;
% eta=0.2;

% hk=0.02;
% eta=0.1;

RES=5000; 


for ind=1:num 
    S=sprintf('\nThis is Iteration %d',ind); %Display the turn of loop
    disp(S);
    
    t1=t0+dt;  
    if t1>TIME
       break;
    end
    % steep descent algorithm    
    x1=x0(1); % current location
    x2=x0(2);    
    lambda=(x1-R*x2)/x1;  

    
    % Banana Function
    [f,grad,H]=mu(lambda);  % obtain function value and gradient
   

    %-----------------------------------------------------------
    % TRUST REGION METHOD
    %-----------------------------------------------------------
    LAMBDA=linspace(0,1,RES);
    k=1;
    
    p=LAMBDA(find(abs(LAMBDA-lambda)<=hk));
    mk=f+grad.*p;%+0.5*H*p.^2;  % mk is build based on gradient,
    [M,I]=min(mk);
    lambdas=p(I);   
    lambdasr(end+1)=lambdas;
     
    % control gramian
    Wc=(1-exp(-2*c*(t1-t0)))/(2*c);
    InvWc=inv(Wc);
    
    % solving the ode
    tspan=[t0 t1];  
    rand('state',0);
    [t,x]=ode23('abs_trustregion_derivatives',tspan,x0);    
    
    for i=1:length(t)
        idx = find(tsave-t(i)==0);
        u(i)=usave(idx(length(idx)));
    end;
     
    % update
    t0=t1;
    x0=x(end,:)
    xhat(:,end+1)=x0(1:2);   % real regulated state
    xreal(Nx+1:Nx+length(x),:)=x;
    Nx=length(xreal)-1;
    ureal(Nu+1:Nu+length(u))=u;
    Nu=length(ureal)-1;    
    treal(Nt+1:Nt+length(t))=t;
    Nt=length(treal)-1;
    usave=[]; tsave=[];   
    
    
    x1=x0(1);  % current location
    x2=x0(2);    
    lambdar=(x1-R*x2)/x1 ;
    
    
    % the ratio will be measured once it is arrived
    r=(f-mu(lambdar))/(f-M);
    if r<0.25
      % hk=hk/4;
      hk=abs(p(I)-lambda)/4;
      if hk<=1/RES;
          hk=1/RES;
      end
    elseif  r>0.75 & abs(p(I))==hk
       hk=2*hk;        
    else
       hk=hk;
    end
    
   
    lambda
    lambdas
    lambdar
    r
    
    if r < eta
        lambdasr(end+1)=lambda;
        lambdas=lambda; 
        t1=t0+dt;
        if t1>TIME
           break;
        end
        tspan=[t0 t1]; 
        x0
        (x0(1)-R*x0(2))/x0(1)   
        lambdar
        lambdas
        rand('state',0);
        [t,x]=ode23('abs_steep_derivatives',tspan,x0);  
        for i=1:length(t)
            idx = find(tsave-t(i)==0);
            u(i)=usave(idx(length(idx)));
        end;
     
        % update
        ind=ind+1
        t0=t1;
        x0=x(end,:)
        xhat(:,end+1)=x0(1:2);   % real regulated state
        xreal(Nx+1:Nx+length(x),:)=x;
        Nx=length(xreal)-1;
        ureal(Nu+1:Nu+length(u))=u;
        Nu=length(ureal)-1;    
        treal(Nt+1:Nt+length(t))=t;
        Nt=length(treal)-1;
        usave=[]; tsave=[];
        x1=x0(1);  % current location
        x2=x0(2);    
        lambda=(x1-R*x2)/x1   
    end       
   % pause
    
end

% trajectory of the states
x1=xreal(:,1);
x2=xreal(:,2);
lambda=(x1-R.*x2)./x1;

% trajectory of the objective function
y=-mu(lambda);

figure 
plot(treal,y,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('\mu(\lambda)','FontSize',18,'FontWeight','bold');
title('Friction Force Coefficient','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'abs_output_tras.eps','psc2');

figure 
plot(treal,lambda,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('\lambda','FontSize',18,'FontWeight','bold');
title('Slip','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'abs_lambda_tras.eps','psc2');


figure
plot(treal,x1,treal,x2,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('x','FontSize',18,'FontWeight','bold');
title('Linear Velocity and Angular Velocity','FontSize',18,'FontWeight','bold');
legend('Linear Velocity','Angular Velocity');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold');
%saveas(gcf,'abs_state_tras.eps','psc2');

figure
plot(treal,ureal(1:length(treal)),'LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('u','FontSize',18,'FontWeight','bold');
title('Braking Torque','FontSize',18,'FontWeight','bold');
grid on;  set(gca,'FontSize',12,'FontWeight','bold');  
%saveas(gcf,'abs_control_tras.eps','psc2');

